function restrict_post_editing_by_lock() {
    global $pagenow;

    if ( $pagenow !== 'post.php' || !isset($_GET['post']) ) return;

    $post_id = intval($_GET['post']);
    if ( !$post_id ) return;

    $lock = get_post_meta($post_id, '_edit_lock', true);
    if ( !$lock ) return;

    list($time, $user_id) = explode(':', $lock);
    if ( (int)$user_id === get_current_user_id() ) return;

    // Check if the lock is still valid (default 150 seconds)
    if ( time() - $time < apply_filters( 'wp_check_post_lock_window', 150 ) ) {
        wp_die( 'This page is currently being edited by another user. Please try again later.' );
    }
}
add_action('admin_init', 'restrict_post_editing_by_lock');
